function [phi_new]=Periodicity(phi,per_x,per_y, per_z)
r=1;
[i, j, k] = size(phi);
mx = max([i, j, k]);
d(1) = (i-1)/(mx-1);
d(2) = (j-1)/(mx-1);
d(3) = (k-1)/(mx-1);
dx = max([d(1), d(2), d(3)])/(mx-1);
[g{1}, g{2}, g{3}] = ndgrid(0:dx:d(1), 0:dx:d(2), 0:dx:d(3));
% since the largest dimension is scaled to 1, set max(phi) equal to 0.2.
phi = 0.2*phi/max(phi(:));
% Periodicity in x, y and z direction
d(1) = per_x*r*d(1)*symx;
d(2) = per_y*r*d(2)*symy;
d(3) = per_z*r*d(3)*symz;
[m, n, o] = size(phi);
dx = max([d(1), d(2), d(3)])/(max([(symx*per_x*(i-1)), ...
    (symy*per_y*(j-1)), (symz*per_z*(k-1))]));
[g{1}, g{2}, g{3}] = ndgrid(0:dx:d(1), 0:dx:d(2), 0:dx:d(3));
phi_new = zeros(per_x*(m-1)+1, per_y*(n-1)+1, per_z*(o-1)+1);
for i = 0:per_x-1
    for j = 0:per_y-1
        for k = 0:per_z-1
            for ii = 1:m
                for jj = 1:n
                    for kk = 1:o
                        phi_new((i*(m-1)+ii), ((j*(n-1)+jj)), ...
                            ((k*(o-1)+kk)))= phi(ii, jj, kk);
                    end
                end
            end
        end
    end
end